<?php

namespace App\Sys\Services\Packages;

use App\Sys\Services;
use App\Sys\Repositories\Packages\SubscriptionRepository;

class SubscriptionService extends Services
{
    protected $subscriptionRepository;

    public function __construct(SubscriptionRepository $subscriptionRepository)
    {
        $this->subscriptionRepository = $subscriptionRepository;
    }

    public function getLatestSubscriptionDetails($userId)
    {
        $subscription = $this->subscriptionRepository->getLatestSubscriptionByUserId($userId);

        if (!$subscription) {
            return false;
        }

        return $subscription;
    }
}
