<?php

namespace App\Http\Controllers\Api\Blogs;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\BlogResource;
use App\Http\Resources\BlogsCollection;
use App\Sys\Services\Blogs\BlogService;
use Illuminate\Http\Request;

class BlogsController extends Controller
{
    use ApiResponse;
    protected $blogService;

    public function __construct(BlogService $blogService)
    {
        $this->blogService = $blogService;
    }

    public function blogs($limit)
    {
        $response = $this->blogService->getBlogs($limit);

        if (! $response) {
            return $this->apiResponse(400, 'Fail', null, null);
        }

        $blogs = new BlogsCollection($response);

        return $this->apiResponse(200, 'All Data', null, $blogs);
    }

    public function blogById($blogId)
    {
        $response = $this->blogService->getBlogById($blogId);

        if (! $response) {
            return $this->apiResponse(400, 'Fail', $this->blogService->errors(), null);
        }

        $blog = new BlogResource($response);

        return $this->apiResponse(200, 'All Data', null, $blog);
    }

    public function blogsByCategoryId(Request $request, int $limit)
    {
        $response = $this->blogService->getBlogsByCategory($request->all(), $limit);

        if (! $response) {
            $error = $this->blogService->errors();
            return $this->apiResponse(400, 'Fail', $error, null);
        }

        $blogs = new BlogsCollection($response);

        return $this->apiResponse(200, 'All Data', null, $blogs);
    }
}
