<?php

namespace App\Http\Controllers\Api\General;

use App\ApiResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Sys\Services\General\CommunicationService;

class CommunicationController extends Controller
{
    use ApiResponse;
    protected $communicationService;

    public function __construct(CommunicationService $communicationService)
    {
        $this->communicationService = $communicationService;
    }

    public function getCommunicationMethods()
    {
        $methods = $this->communicationService->getAllMethods();

        if (! $methods) {
            return $this->apiResponse(400, 'fail', null, null);
        }

        return $this->apiResponse(200, 'All data', null, $methods);
    }
    public function handleContactForm(Request $request)
    {
        $user = Auth::guard('api')->user();

        $communication = $this->communicationService->handleContactFormSubmission($user, $request->all());

        if (! $communication) {
            $error = $this->communicationService->errors();
            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'All data', null, null);
    }
}
