<?php

namespace App\Http\Controllers\Api\General;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Sys\Services\Packages\PackageVideoService;
use App\Sys\Services\Packages\SubscriptionService;
use Illuminate\Support\Facades\Auth;

class GeneralPackageControllers extends Controller
{
    use ApiResponse;

    protected $subscriptionService;

    protected $packageVideoService;

    public function __construct(
        SubscriptionService $subscriptionService,
        PackageVideoService $packageVideoService
    ) {
        $this->subscriptionService = $subscriptionService;
        $this->packageVideoService = $packageVideoService;
    }

    public function getSubscriptionDetails()
    {
        $userId = Auth::guard('api')->user()->id;

        $response = [
            'package_id' => null,
            'package_name' => null,
            'subscription_expiration_date' => null,
            'package_video_id' => null,
            'package_video_name' => null,
            'package_video_expiration_date' => null,
        ];

        $subscription = $this->subscriptionService->getLatestSubscriptionDetails($userId);

        if ($subscription) {
            $response['package_id'] = $subscription->package_id;
            $response['package_name'] = $subscription->package->getNameAttribute();
            $response['subscription_expiration_date'] = $subscription->expiration_date;
        }

        $packageVideo = $this->packageVideoService->getPackageVideoDetails($userId);

        if ($packageVideo) {
            $response['package_video_id'] = $packageVideo->id;
            $response['package_video_name'] = $packageVideo->package->getNameAttribute();
            $response['package_video_expiration_date'] = $packageVideo->expiration_date;
        }

        return $this->apiResponse(200, 'All Data', null, $response);
    }
}
