<?php

namespace App\Http\Controllers\Api\Theories;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\TheoryPackageCollection;
use App\Http\Resources\TheoryPackageResource;
use App\Sys\Services\Theories\TheoryPackageService;

class TheoryController extends Controller
{
    use ApiResponse;
    protected $theoryPackageService;

    public function __construct(TheoryPackageService $theoryPackageService)
    {
        $this->theoryPackageService = $theoryPackageService;
    }

    public function theories($limit)
    {
        $response = $this->theoryPackageService->getTheories($limit);

        if (! $response) {
            return $this->apiResponse(400, 'Fail', null, null);
        }

        $theories = new TheoryPackageCollection($response);

        return $this->apiResponse(200, 'All Data', null, $theories);
    }

    public function theoryById($theoryId)
    {
        $response = $this->theoryPackageService->getTheoryById($theoryId);

        if (! $response) {
            return $this->apiResponse(400, 'Fail', $this->theoryPackageService->errors(), null);
        }

        $theory = new TheoryPackageResource($response);

        return $this->apiResponse(200, 'All Data', null, $theory);
    }
}
