<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BlogCategoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'slug' => $this->slug,
            'arrangement' => $this->arrangement,
            'photo' => $this->photo,
            'photo_extension' => $this->checkExtions($this->photo),
        ];
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array(pathinfo($pro, PATHINFO_EXTENSION), ["jpg", "jpeg", "gif", "png", "bmp", "webp", "PNG", "GIF", "JPG"]))
                return 'photo';

            return 'video';
        }

        return null;
    }
}
