<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ExamsResource extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->examName,
            'description' => $this->description,
            'questions_count' => $this->questions_num,
            'attempt_count' => $this->attempt_num,
            'duration_in_minutes' => $this->duration_in_minutes,
            'exam_category_auto_move' => $this->exam_category_auto_move,
            'color_background' => $this->color_background,
            'color_border' => $this->color_border,
            'photo' => $this->photo_phone,
            'photo_extension' => $this->checkExtions($this->photo_phone),
            'is_locked' => ($this->attempts_count ?? 0) >= $this->attempt_num,
        ];
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array(pathinfo($pro, PATHINFO_EXTENSION), ["jpg", "jpeg", "gif", "png", "bmp", "webp", "PNG", "GIF", "JPG"]))
                return 'photo';

            return 'video';
        }

        return null;
    }
}
