<?php

namespace App\Sys\Repositories\Blogs;

use App\Models\Blog;

class BlogRepository
{
    public function getPaginatedBlogs($limit)
    {
        return Blog::query()
            ->latest()
            ->paginate($limit);
    }

    public function getPaginatedBlogsByCategoryId($categoryId, $limit)
    {
        return Blog::query()
            ->where('blog_category_id', $categoryId)
            ->latest()
            ->paginate($limit);
    }

    public function getSelectedBlog($blogId)
    {
        return Blog::query()
            ->find($blogId);
    }
}
