<?php

namespace App\Sys\Repositories\Packages;

use App\Models\Videos;
use App\Models\PackageVideo;
use App\Models\PackageVideoUserWatch;
use App\Models\PackageVideoSubscriptions;

class PackageVideoRepository
{
    public function getActivePackageVideoSubscriptionByUserId($userId)
    {
        return PackageVideoSubscriptions::query()
            ->with('package')
            ->where('user_id', $userId)
            ->where('expiration_date', '>=', now())
            ->latest('subscription_date')
            ->first();
    }
    public function getActiveVideoPackages($limit)
    {
        return PackageVideo::query()
            ->with('offer')
            ->where('active', 1)
            ->orderBy('arrangement')
            ->paginate($limit);
    }
    public function getVideosWithProgress($userId, $packageId, $activeSubscriptionId)
    {
        return PackageVideo::query()
            ->with(['video' => function ($query) use ($userId, $activeSubscriptionId) {
                $query->with(['videoShows' => function ($query) use ($userId, $activeSubscriptionId) {
                    $query->where('user_id', $userId)
                        ->where('subscription_id', $activeSubscriptionId);
                }]);
            }])->find($packageId);
    }
    public function getVideoUsingIdWithProgress($userId, $videoId, $packageId, $activeSubscriptionId)
    {
        return Videos::query()
            ->whereHas('packageVideo', function ($query) use ($packageId) {
                $query->where('package_video.id', $packageId);
            })
            ->with(['videoShows' => function ($query) use ($userId, $activeSubscriptionId) {
                $query->where('user_id', $userId)
                    ->where('subscription_id', $activeSubscriptionId);
            }])->find($videoId);
    }

    public function incrementWatchCount($userId, $videoId, $packageVideoSubscription, $videoShows = null)
    {
        if ($videoShows) {
            // If the videoShow exists, increment the count_watch
            $videoShows->count_watch += 1;
            $videoShows->save();
        } else {
            // If no entry exists, create a new PackageVideoVideo object
            $packageVideoVideo = new PackageVideoUserWatch();
            $packageVideoVideo->video_id = $videoId;
            $packageVideoVideo->user_id = $userId;
            $packageVideoVideo->package_id = $packageVideoSubscription->package_id;
            $packageVideoVideo->subscription_id = $packageVideoSubscription->id;
            $packageVideoVideo->count_watch = 1;
            $packageVideoVideo->save();
        }
    }
}
