<?php

namespace App\Sys\Services\General;

use App\Sys\Repositories\General\StaticPageRepository;
use App\Sys\Services;

class StaticPageService extends Services
{
    protected $staticPageRepository;

    public function __construct(StaticPageRepository $staticPageRepository)
    {
        $this->staticPageRepository = $staticPageRepository;
    }
    public function staticContentByPageType($type)
    {
        $preselectedTypes = [
            // Type => id in database
            'privacy' => 2,
            'about' => 3,
        ];

        if (!isset($preselectedTypes[$type])) {
            return false;
        }

        $staticId = $preselectedTypes[$type];

        return $this->staticPageRepository->getStaticContent($staticId);
    }
}
