<?php

namespace App\Sys\Services\Packages;

use App\Sys\Services;
use App\Sys\Repositories\Packages\PackageVideoRepository;

class PackageVideoService extends Services
{
    protected $packageVideoRepository;

    public function __construct(PackageVideoRepository $packageVideoRepository)
    {
        $this->packageVideoRepository = $packageVideoRepository;
    }

    public function getPackageVideoDetails($userId)
    {
        $packageVideo = $this->packageVideoRepository->getActivePackageVideoSubscriptionByUserId($userId);

        if (!$packageVideo) {
            return false;
        }

        return $packageVideo;
    }

    public function getActivePackages($limit)
    {
        $packageVideo = $this->packageVideoRepository->getActiveVideoPackages($limit);

        if (!$packageVideo) {
            return false;
        }

        return $packageVideo;
    }

    public function getVideosWithWatchProgress($userId)
    {
        $packageVideoSubscription = $this->packageVideoRepository->getActivePackageVideoSubscriptionByUserId($userId);

        if (! $packageVideoSubscription) {
            $this->setError('No active subscription');
            return false;
        }

        $videos = $this->packageVideoRepository->getVideosWithProgress($userId, $packageVideoSubscription->package_id, $packageVideoSubscription->id);

        if (! $videos) {
            $this->setError('No available videos');
            return false;
        }

        return $videos;
    }

    public function getSelectedVideoById($userId, $videoId)
    {
        $packageVideoSubscription = $this->packageVideoRepository->getActivePackageVideoSubscriptionByUserId($userId);

        if (! $packageVideoSubscription) {
            $this->setError('No active subscription');
            return false;
        }

        $video = $this->packageVideoRepository->getVideoUsingIdWithProgress($userId, $videoId,  $packageVideoSubscription->package_id, $packageVideoSubscription->id);

        if (! $video) {
            $this->setError('Not available videos');
            return false;
        }

        $videoShow = $video->videoShows->first();

        if ($videoShow && $videoShow->count_watch >= $packageVideoSubscription->one_count_play) {
            $this->setError('You have exceeded your permitted attempt');
            return false;
        }

        $this->packageVideoRepository->incrementWatchCount($userId, $videoId, $packageVideoSubscription, $videoShow);

        // Getting the correct current watch count after incrementing the watch count.
        $video->refresh();

        return $video;
    }
}
