<?php

namespace App\Sys\Services\Theories;

use App\Sys\Repositories\Theories\TheoryPackageRepository;
use App\Sys\Services;

class TheoryPackageService extends Services
{
    protected $theoryPackageRepository;

    public function __construct(TheoryPackageRepository $theoryPackageRepository)
    {
        $this->theoryPackageRepository = $theoryPackageRepository;
    }

    public function getTheories($limit)
    {
        $theories =  $this->theoryPackageRepository->getPaginatedTheories($limit);

        if (! $theories)
            return false;

        return $theories;
    }

    public function getTheoryById($theoryId)
    {
        $theory =  $this->theoryPackageRepository->getSelectedTheory($theoryId);

        if (! $theory) {
            $this->setError('theory not found');
            return false;
        }

        return $theory;
    }
}
