@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Create Subscribtion') }}</h3>
            </div>

        </div>
    </div>

    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }
    </style>
    <!-- Main content -->

    <section class="content">
        {!! Form::open([
            'method' => 'post',
            'route' => ['package_video.updatedProcessSub', $sub->id],
            'files' => true,
            'id' => 'edit-theoryPackage-form',
        ]) !!}
        <div class="row">
            <div class="col-lg-8 mx-auto">

                <div class="box">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group" style="padding: 1em;">
                                    <label for="expiration_date">{{ trans('messages.Expiration date') }}
                                    </label>
                                    <div>
                                        {!! Form::datetimeLocal('date', $sub->expiration_date, [
                                            'class' => 'form-control',
                                            'placeholder' => trans('messages.Expiration date'),
                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md">
                                <div class="form-group" style="padding: 1em;">
                                    <label for="expiration_date">{{ trans('messages.totalViewVideo') }}
                                    </label>
                                    <div>
                                        {!! Form::number('count_play', $sub->count_play, [
                                            'class' => 'form-control',
                                            'placeholder' => trans('messages.totalViewVideo'),
                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md">
                                <div class="form-group" style="padding: 1em;">
                                    <label for="expiration_date">{{ trans('messages.one_count_play') }}
                                    </label>
                                    <div>
                                        {!! Form::number('one_count_play', $sub->one_count_play, [
                                            'class' => 'form-control',
                                            'placeholder' => trans('messages.one_count_play'),
                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::Close() !!}
    </section>
@endsection


@section('script')
    <script type="text/javascript"></script>
@endsection
