<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::namespace('Api')->group(function () {
    // Auth Controllers
    Route::prefix('auth')->group(function () {
        Route::namespace('Auth')->group(function () {
            Route::post('/login', 'AuthController@login')->name('auth.login');
            Route::post('/register', 'AuthController@register')->name('auth.register');
            Route::get('/me', 'AuthController@me')->name('auth.me')->middleware('CheckAuthApi');
            Route::post('/reset/otp', 'AuthController@getResetPassword')->name('auth.reset-otp');
            Route::post('/reset/password/otp', 'AuthController@ressetpassword')->name('auth.reset-password-otp');
            Route::post('/updated', 'AuthController@updated')->name('auth.updated')->middleware('CheckAuthApi');
            Route::post('/updated/password', 'AuthController@password')->name('auth.updated-password')->middleware('CheckAuthApi');
        });
    });
    // any general data
    Route::prefix('general')->group(function () {
        Route::namespace('General')->group(function () {
            Route::get('/payment-method', 'PaymentControllers@getPaymentMethods')->name('general.payment-methods');
            Route::get('/checkPayment/{id}', 'PaymentControllers@checkPayment')->name('general.checkPayment');
            Route::get('redirectUrl-api-payment', 'PaymentControllers@redirectUrl')->name('general.redirectUrl');
            Route::get('/communication/methods', 'CommunicationController@getCommunicationMethods')->name('general.communication.methods');
            //ContactUs form
            Route::post('/communication/contact-us/send', 'CommunicationController@handleContactForm')->name('general.communication.contactUs');
            //About & privacy
            Route::get('/static-content/{type}', 'ContentController@getStaticPageContent')->name('general.contentPage');
        });
    });
    Route::prefix('packages')->group(function () {
        //package exam
        Route::namespace('Packages')->group(function () {
            Route::get('get/{limit}', 'PackageController@packages')->name('packages.active');
        });

        //Video package
        Route::namespace('Packages')->group(function () {
            Route::get('/videos/get/{limit}', 'PackageVideoController@packages')->name('packages-video.active');
            Route::get('/subscribed-videos/get', 'PackageVideoController@subscribedPackageVideos')->name('subscribed.package.video');
            Route::get('/videos/get/select/{id}', 'PackageVideoController@getSelectedVideo')->name('subscribedPackage.video.select');
        });

        // the current active package's exams + showing is_locked for when the attempts exceeds the attempts for each exam
        Route::prefix('exams')->group(function () {
            Route::namespace('Exams')->group(function () {
                Route::get('/user/subscribed-exams/{limit}', 'ExamController@getSubscribedPackageExams')->name('user.subscribed-exams');
                Route::get('/exam-questions', 'ExamController@getSubscribedPackageExamQuestions')->name('subscribed-exams.questions');
                Route::get('/test-exam-questions', 'ExamController@getTestPackageExamQuestions')->name('test-exams.questions');
                Route::post('/exam-results', 'ExamController@saveExamResults')->name('exams.questions-answer');
            });
        });

        Route::namespace('General')->group(function () {
            Route::get('/mySubscription-details', 'GeneralPackageControllers@getSubscriptionDetails')->name('general.SubscriptionDetails');
        });
    });
    Route::prefix('questions')->group(function () {
        Route::namespace('questions')->group(function () {
            //favorite question
            Route::get('/favorite-questions/get/{limit}', 'FavoriteQuestionController@getFavoriteQuestions')->name('favoriteQuestions.get');
            Route::get('/favorite-question/{id}', 'FavoriteQuestionController@getSelectedFavoriteQuestion')->name('favoriteQuestion.get');
            Route::post('/favorite-questions/fav/add', 'FavoriteQuestionController@addFavorite')->name('favoriteQuestion.add');
            Route::post('/favorite-questions/fav/remove',  'FavoriteQuestionController@removeFavorite')->name('favoriteQuestion.remove');
            //report question
            Route::post('report/question', 'ReportQuestionController@reportQuestion')->name('report.question.create');
        });
    });

    Route::prefix('exams')->group(function () {
        Route::namespace('Exams')->group(function () {
            Route::get('/exam-questions/{id}', 'ExamController@getSubscribedPackageExamQuestions')->name('subscribed-exams.questions');
        });
    });
    Route::prefix('results')->group(function () {
        Route::namespace('Results')->group(function () {
            Route::get('/all-progress', 'ProgressController@ExamPackageProgress')->name('progress-exams.results');
        });
    });

    // Blog
    Route::prefix('blog')->group(function () {
        Route::namespace('Blogs')->group(function () {
            // Blog category
            Route::get('/categories/{limit}', 'BlogCategoriesController@categories')->name('load.blogCategories.limit');
            Route::get('/category/post/{limit}', 'BlogsController@blogsByCategoryId')->name('load.CategoriesBlogs.limit');
            // Blog posts
            Route::get('/posts/get/{limit}', 'BlogsController@blogs')->name('load.blogs.limit'); //All posts
            Route::get('/post/{id}', 'BlogsController@blogById')->name('blog.post.get');
        });
    });

    // Theory
    Route::prefix('theory')->group(function () {
        Route::namespace('theories')->group(function () {
            Route::get('/packages/get/{limit}', 'TheoryController@theories')->name('load.theories.limit');
            Route::get('/get/{id}', 'TheoryController@theoryById')->name('theory.get');
        });
    });
});

// web hock
Route::post('mollie-webhooks/{type}', [App\Http\Controllers\Site\ClientController::class, 'handleWebhookNotification'])->name('webhooks.mollie');
Route::post('mollie-webhooks-theory', [App\Http\Controllers\Site\ClientController::class, 'handleWebhookTheoryNotification'])->name('webhooks.mollieTheory');
Route::post('mollie-webhooks-packageVideos', [App\Http\Controllers\Site\PackagesVideosControllers::class, 'handleWebhookpackageVideos'])->name('webhooks.packageVideos');
